Review

# Traditional Chinese Medicine in the Treatment of Patients Infected with 2019-New Coronavirus (SARS-CoV-2): A Review and Perspective

Yang Yang\*, Md Shahidul Islam\*, Jin Wang, Yuan Li and Xin Chen

tate Key Laboratory of Quality Research in Chinese Medicine, Institute of Chinese Medical Sciences, University of Macau, Macau SAR 999078, China

\*These authors have contributed equally to this work.

 Corresponding author: Prof. Xin Chen, Institute of Chinese Medical Sciences, University of Macau, Avenida da Universidade, Taipa, Macau SAR 999078, China. Tel.: (853) 8822 4513; Fax: (853) 2884 1358. E-mail address: xchen@um.edu.mo; ORCID: http://orcid.org/0000-0002-2628-4027

The author(s). This is an open access article distributed under the terms of the Creative Commons Attribution License (https://creativecommons.org/licenses/by/4.0/).   
See http://ivyspring.com/terms for full terms and conditions.

Received: 2020.03.02; Accepted: 2020.03.08; Published: 2020.03.15

# Abstract

Currently, Severe Acute Respiratory Syndrome Coronavirus 2 (SARS-CoV-2, formerly known as 2019-nCoV, the causative pathogen of Coronavirus Disease 2019 (COVID-19)) has rapidly spread across China and around the world, causing an outbreak of acute infectious pneumonia. No specific anti-virus drugs or vaccines are available for the treatment of this sudden and lethal disease. The supportive care and non-specific treatment to ameliorate the symptoms of the patient are the only options currently. At the top of these conventional therapies, greater than $85 \%$ of SARS-CoV-2 infected patients in China are receiving Traditional Chinese Medicine (TCM) treatment. In this article, relevant published literatures are thoroughly reviewed and current applications of TCM in the treatment of COVID-19 patients are analyzed. Due to the homology in epidemiology, genomics, and pathogenesis of the SARS-CoV-2 and SARS-CoV, and the widely use of TCM in the treatment of SARS-CoV, the clinical evidence showing the beneficial effect of TCM in the treatment of patients with SARS coronaviral infections are discussed. Current experiment studies that provide an insight into the mechanism underlying the therapeutic effect of TCM, and those studies identified novel naturally occurring compounds with anti-coronaviral activity are also introduced.

Key words: SARS-CoV-2, Traditional Chinese Medicine (TCM), coronavirus pneumonia

# Introduction

In December 2019, there was an outbreak of unexplainable pneumonia in Wuhan city, Hubei province, China [1]. By Jan 7, 2020, it was confirmed that a new type of coronavirus named SARS-CoV-2 (formerly named as 2019-nCoV) had emerged [2]. The World Health Organization (WHO) named the Wuhan pneumonia as Coronavirus Disease-2019 (COVID-19) on Feb 11, 2020 [3]. The COVID-19 patients showed typical respiratory symptom (such as cough, fever, and lung damage) and some other symptoms such as fatigue, myalgia, and diarrhea $[ 4 ,$ 5]. As of February 17, 2020, a total of 73,332 cases of the SARS-CoV-2 infected pneumonia has been reported in China and 25 other countries, of which 72,528 cases was found in China [6]. Due to the rapid spread of SARS-CoV-2 through human-to-human transmission, the cases currently continue to rise. SARS-CoV-2 extracted from patients with pneumonia in Wuhan is an enveloped single stranded RNA-type beta-coronavirus [7]. The genome sequences of SARS-CoV-2 shared $7 9 . 5 \%$ sequence identity to severe acute respiratory syndrome-related coronaviruses (SARS-CoV) [8, 9]. In addition, the spike (S) protein of SARS-CoV-2 and SARS-CoV enters human alveolar epithelial cells through binding angiotensinconverting enzyme 2 (ACE2) receptor [8].

COVID-19 can be diagnosed by either chest CT radiography or a laboratory testing. Unfortunately, specific antiviral drugs or vaccines currently have not been available for the treatment [10, 11]. According to the current clinical guideline in China and the experiences in the treatment of SARS or Middle East Respiratory Syndrome (MERS) patients, both conventional medicine and traditional Chinese medicine (TCM) are used for the treatment of patients with infection of SARS-CoV-2 in China [12-14]. This review mainly focuses on the discussion of TCM usage in the treatment of COVID-19 patients, in the context of current conventional management. Due to the homology in epidemiology, genomics, and pathogenesis of the SARS-CoV-2 and SARS-CoV [8, 9], and widely usage of TCM in the treatment of patients infected with SARS-CoV in 2002-2003 [15], the clinical evidence showing the efficacy and safety of TCM in the treatment of patients with the emerging coronaviral will be summarized and analyzed, including the laboratory studies that provide an insight into molecular basis of therapeutic benefits.

# Conventional treatment of SARS-CoV-2: is there a room for Chinese medicine?

Due to the absence of a specific antiviral therapeutics and vaccine, main treatment strategy for COVID-19 is supportive care, which is supplemented by the combination of broad-spectrum antibiotics, antivirals, corticosteroids and convalescent plasma [16] (Table 1). HIV protease inhibitors ritonavir and lopinavir have been used, typically in combination with appropriate antibiotics or with $\mathrm { I F N a } { - } 2 \mathrm { b } ,$ in the treatment of SARS-CoV-2 infected patients [7, 17]. Nucleoside analogs such as ribavirin [12] may be potentially beneficial for the treatment of COVID-19, since ribavirin was approved for treating respiratory syncytial virus (RSV) infection [18] and used extensively during the SARS and MERS outbreak [10]. However, ribavirin had severe side effects such as anemia [18] and whether it had sufficient antiviral activity against SARS-CoV-2 is unclear. Nucleoside analogs favipiravir (T-705) can effectively inhibit the activity of RNA polymerase of RNA viruses such as influenza [19]. A recent in vitro study found that it had the anti-SARS-CoV-2 activity [20], but the in vivo effect remains elusive. Remdesivir may be the most promising antiviral drug for treating COVID-19. It has in vitro and in vivo antiviral activity against a wide array of RNA viruses including SARS and MERS [21], and could decrease viral loads and pathology of lungs in animal models [22]. A study showed remdesivir markedly inhibited the infection of SARS-CoV-2 in Vero E6 cells [20], and most symptoms of the first US patient infected with SARS-CoV-2 had resolved swiftly after intravenous administration with remdesivir [23]. Currently, it is under clinical trial to evaluate the safety and efficacy of intravenous remdesivir for patients with SARS-CoV-2 infection [24]. Oral oseltamivir has been used for the treatment of the cases with SARS-CoV-2 [7], while its efficacy currently remains uncertain.

Table 1. Conventional treatment of patients with SARS-CoV-2 infection   

<html><body><table><tr><td>Type of treatment</td><td>Therapeutic agent or device</td><td>Reference</td></tr><tr><td rowspan="3">Oxygen therapy</td><td>Nasal cannula</td><td>[16]</td></tr><tr><td>Non-invasive mechanical ventilation Invasive mechanical ventilation</td><td></td></tr><tr><td>ECMO* Amoxicillin Azithromycin</td><td>[16]</td></tr><tr><td rowspan="6">Antivirals</td><td>Fluoroquinolones Lopinavir/ ritonavir</td><td>[16,17]</td></tr><tr><td>Ribavirin</td><td>[16,18]</td></tr><tr><td>Favipiravir (T-705)</td><td>[19,20]</td></tr><tr><td>Remdesivir</td><td>[20-23]</td></tr><tr><td>Oseltamivir</td><td>[7]</td></tr><tr><td>Chloroquine</td><td>[20,36] [7,17]</td></tr><tr><td>Corticosteroids</td><td>Interferon</td></tr><tr><td></td><td></td></tr><tr><td>Convalescent plasma</td><td></td></tr><tr><td>Methylprednisolone Convalescent plasma</td><td>[7] [22]</td></tr></table></body></html>

\*ECMO, extracorporeal membrane oxygenation.

Host-targeted small molecules approved for other human diseases may modulate the virus-host interactions of SARS-CoV-2. Chloroquine, a potential broad-spectrum antiviral drug [25, 26], was shown by a recent study had anti-SARS-CoV-2 activity [20]. Its clinical efficacy is under study in an open-label trial (ChiCTR2000029609) [12]. IFNα (5 million U) atomization inhalation was recommended as antiviral therapy to treat SARS-CoV-2 [16]. A trial testing IFNα-2b combination of the approved anti-HCV inhibitors has been initiated [17], however, whether it could act synergistically against SARS-CoV-2 is unclear.

Corticosteroids were frequently used to suppress the elevated cytokine levels in patients with SARS-CoV [27, 28] and MERS-CoV [29, 30]. However, there are no evidence showing that the mortality of SARS and MERS patients was reduced by the treatment with corticosteroids, while the clearance of viral was delayed by such treatment [31-33]. Consequently, corticosteroids are not suggested to systemically use in SARS-CoV-2 infected patients [34, 35].

Previously, it was shown that, either in severe influenza or SARS-CoV infection, convalescent plasma treatment could significantly decrease viral load and reduce the mortality [31, 36]. Convalescent plasma has been used for severe SARS-CoV-2 infection in China [22], although promising, the efficacy and safety need to be carefully further evaluated.

Consistent with previous analysis, WHO also concluded that "to date, there is no specific medicine recommended to prevent or treat SARS-CoV-2" [37]. TCM has been used in control of infectious diseases for thousands of years. There is a clear room for the intervention of TCM as a complementary therapy for COVID-19 patients. It is reported that the patients with SARS-CoV infection have benefited from TCM treatment [38], including amelioration of side effect of conventional therapeutics [39, 40]. Based on these factors, there is a general expectation that TCM would be a valuable weapon in the armory against SARS-CoV-2.

# Traditional Chinese Medicine in the treatment of patients infected with SARS-CoV: clinical evidence

Application of TCM in the treatment of SARS-CoV-2 is largely inspired by the treatment of SARS caused by outbreak of SARS coronavirus (SARS-CoV) in the late of 2002 in the Guangdong Province of China which spread rapidly during the 2003, with the cumulative number worldwide of over 8,000 [41-43]. Ranging from case reports, case series, controlled observational studies and randomized clinical trials, clinical studies aiming to examine the effect of TCM on SARS have been carried out and reported. There are quite compelling evidences support the notion that TCM has beneficial effect in the treatment or prevention of SARS. For example, the rate of fatality in Hong Kong and Singapore was approximately $1 8 \%$ , while the rate for Beijing was initially more than $5 2 \%$ until the $5 ^ { \mathrm { t h } }$ of May and decreased gradually to $4 \% - 1 \%$ after the $2 0 ^ { \mathrm { t h } }$ of May in 2003. The dramatic reduced fatality from late May in Beijing was believed to be associated with the use of TCM as a supplement to the conventional therapy [44]. Lau and colleagues reported that, during SARS outbreak, 1063 volunteers including 926 hospital workers and 37 laboratory technicians working in high-risk virus laboratories used a TCM herbal extract, namely Sang $J u$ Yin plus Yu Ping Feng San. Compared with the $0 . 4 \%$ of infection in the control group, none of TCM users infected. Furthermore, there was some evidence that Sang Ju Yin plus Yu Ping Feng San could modulate T cells in a manner to enhance host defense capacity [45, 46]. In a controlled clinical study, the supplementary treatment with TCM resulted in marked improvement of symptoms and shortened the disease course [47]. The clinical beneficial effect of TCM appears to be supported by laboratory studies. For example, a high-profile research published in the Lancet reported that glycyrrhizin, a major active constituent liquorice root which is the most frequently used Chinese herb, potently inhibited the replication of clinical isolates of SARS virus [48]. Another independent study confirmed the antivirus activity of glycyrrhizin by plaque reduction assays and this study found that another Chinese herbal compound baicalin also had the anti-SARS activity [49]. Furthermore, Wang et al. found MOL376, a compound derived from TCM, may become a lead compound for SARS therapy by inhibition of cathepsin $\scriptstyle \mathrm { { L , } }$ a target for the treatment of SARS [50].

There is a myriad of literature on TCM treatments for SARS published after the SARS epidemic in China. A critical analysis of these publications would be useful to confirm the beneficial effect of TCM. Liu et al. systematically reviewed eight randomized controlled trials, and concluded that, by combination with conventional medicine, TCM showed the beneficial effects such as decrease of mortality and relief of symptom, as well as control of fungal infections in patients with SARS. However, the evidence is not sufficient enough due to the poor quality of methodology used in the trials [13]. Leung analyzed 90 peer-reviewed papers with reasonable quality from 130 publications and concluded that TCM used together with conventional treatment had some positive effects, including better control of fever, quicker clearance of chest infection and other symptoms. However, such beneficial effect of TCM is not conclusive and more high-quality clinical studies are required [15]. In another thorough literature analysis, Liu and colleagues concluded that there was no benefit of adjuvant treatment with TCM in terms of mortality [39]. Due to the lack of high quality TCM trials and biases that influenced the validity of results, Wu and colleagues suggested to re-run clinical trials of TCM for the treatment of acute respiratory tract infections (ARTIs) [51].

# Identification of anti-novel coronaviral compound from Traditional Chinese Medicine

Natural products used in TCM remains to be a wealthy source for the identification of novel therapeutic agents for the treatment of human diseases [52]. In the past decade, scientists have made a considerable effort to identify multiple component herbal formulae in TCM with anti-SARS-CoV activity (Table 2). Further identification of chemical entities contained in TCM herbs responsible for the anti-SARS- CoV effect was also pursued (Table 3). Due to the homology of SARS-CoV and SARS-CoV-2, these previous studies may shed light on the naturally occurring compounds with the capacity to inhibit SARS-CoV-2.

3- chymotrypsin-like protease (3CLpro) is vital for replication of virus, and thus represents a promising drug target for the development of therapeutics agents for SARS-CoV as well as other human coronaviruses including SARS-CoV-2. It was reported that following TCM herbal extracts had the capacity to inhibit the enzymatic activity of SARS 3CLpro: Chinese Rhubarb extracts (IC50: $1 3 . 7 6 \pm 0 . 0 3$ $\mu \mathrm { g } / \mathrm { m L } )$ [53], water extract of Houttuynia cordata [54, 55], flavonoid extracted from litchi seeds [56] and beta-sitosterol (IC50: $1 2 1 0 \mu \mathrm { M } )$ ) extracted from the root extract of Isatis indigotica [57]. Further, following herb-derived naturally occurring compounds including sinigrin (IC50: $2 1 7 \mu \mathrm { M } )$ , indigo (IC50: $7 5 2 \mu \mathrm { M } )$ , aloe-emodin (IC50: $3 6 6 ~ \mu \mathrm { M } )$ , hesperetin (IC50:8.3 $\mu \mathrm { M } )$ [57], quercetin (IC50: $7 3 \mu \mathrm { M } )$ , epigallocatechin gallate (IC50: $7 3 \mu \mathrm { M } )$ , gallocatechin gallate (IC50: $4 7 ~  { \mu \mathrm { M } } )$ [58], herbacetin, rhoifolin and pectolinarin [59] were able to inhibit the SARS 3CLpro activity. Moreover, the flavonoids namely herbacetin, isobavaschalcone, quercetin 3‐ $\boldsymbol { \cdot } \boldsymbol { \beta }$ ‐D‐glucoside, and helichrysetin had the potential to block the enzymatic activity of MERS‐CoV 3CL protease [60].

Table 2. TCM herb formulae used for the Treatment of SARS-CoV infection   

<html><body><table><tr><td>TCM Formula</td><td>Composition</td><td>Therapeutics effect</td><td>Reference</td></tr><tr><td rowspan="3">Yin Qiao San</td><td rowspan="3">FructusForsythie,FlosLoncere,RadixPatycodonis Herba Menthae,HerbaLophatheri,Radix Glycyrrhizae, Rhizoma Phragmitis</td><td>&quot;Disperses wind-heat,clears heat,and relieves toxicity&quot;, according to TCM theory</td><td rowspan="3">[111, 112]</td></tr><tr><td>Herba Schizonepetae,ermentedsoybean,ructuscti,and reatmentofupperspiratorytractinection</td></tr><tr><td>Improvement of the function of upper respiratory mucosal immune system</td></tr><tr><td rowspan="3">Yu Ping Feng San</td><td rowspan="3">Astragali radix,Astragalus membranaceus,Atractylodes macrocephala,and Saposhnikoviae Radix</td><td>&quot;Tonifying&quot;qi&quot; toprotect from externalpathogens&quot;,accrding[-115]</td><td rowspan="3"></td></tr><tr><td>to TCM theory Reportedly have antiviral,anti-inflammatory and</td></tr><tr><td>immunoregulatory effects Reportedly have anti-viral and immunoregulatory effects</td></tr><tr><td>Sang Ju Yin and Yu Ping Feng San Lian Hua Qing Wen</td><td rowspan="4">Sang Ju Yin [made with chrysanthemum,mulberry leaf, and 6 other herbsl and Yu Ping Feng San Forsythiaspccecati&quot;rifsgssdg indigotica,enthahaplocalyx,ryopteris rassirhizoma, Rhodiola rosea, Gypsum Fibrosum,Pogostemon ablin,</td><td></td><td>[46]</td></tr><tr><td rowspan="3">Capsule Rheum palmatum,Houttuynia cordata,Glycyrrhiza</td><td>TCM theory</td><td rowspan="3"></td></tr><tr><td>Reportedly have antiviral,anti-inflammatory and immunoregulatory effects.</td></tr><tr><td>&quot;Clear heat and detoxify,remove lung hotness&quot;,according to[78,80,116]</td></tr><tr><td rowspan="2">Ma Xin Gan Shi Tang</td><td rowspan="2">suspensa Ephedrae herba,Armeniacae semenamarum),Glycyrrhizae</td><td>TCM theory Reportedly has anti-SARS-CoV-2 activity Reportedly has immunosuppressive effects</td><td rowspan="2"></td></tr><tr><td>&quot;Facilitate the flow of the lung&quot;qi&quot;and clear away heat&quot;, according to TCM theory Reportedly have anti-ARS-CoV activity</td></tr></table></body></html>

Table 3. TCM herbal extracts or TCM-derived Compounds with anti-HCoV Activity   

<html><body><table><tr><td>TCM Compound (s)</td><td>Mode of action</td><td>Reference</td></tr><tr><td>Plant-derived phenolic compounds and Root extract of Isatis indigotica</td><td>Inhibit the cleavage activity of SARS-3CLpro enzyme</td><td>[57]</td></tr><tr><td>Water extract of Houttuynia cordata</td><td>Inhibit the viral SARS-3CLpro activity Block viral RNA-dependent RNA polymerase activity (RdRp)</td><td>[54,55]</td></tr><tr><td>Scutellarein and myricetin</td><td>Immunomodulation Inhibit nsP13 by affecting the ATPase activity</td><td>[61]</td></tr><tr><td>Glycyrrhizin from Glycyrrhiza radix</td><td>Inhibit viral adsorption and penetration</td><td>[48,75]</td></tr><tr><td>Herbacetin, quercetin, isobavaschalcone,3-β-D-glucoside and</td><td>Inhibit cleavage activity of MERS-3CLpro enzyme</td><td>[60]</td></tr><tr><td>helichrysetin Tetrandrine,fangchinoline,and cepharanthine</td><td>Inhibit the expression of HCoV- OC43 spike and nucleocapsid protein.</td><td>[106,119]</td></tr><tr><td>Chinese Rhubarb extracts</td><td>Immunomodulation</td><td></td></tr><tr><td>Flavonoids (For example: extracted from litchi seeds, herbacetin, rhoifolin, pectolinarin, quercetin, epigallocatechin</td><td>Inhibit SARS-3CLpro activity Inhibit SARS-3CLpro activity</td><td>[53] [56,58,59]</td></tr><tr><td>gallate,and gallocatechin gallate)</td><td></td><td></td></tr><tr><td>Quercetin and TSL-1 from Toona sinensis Roem Emodin derived from genus Rheum and Polygonum</td><td>Inhibit the cellular entry of SARS-CoV Inhibit interaction of SARS-CoV Spike protein and ACE2</td><td>[76] [67,72]</td></tr><tr><td></td><td>Inhibit the 3a ion channel of coronavirus SARS-CoV and HCoV-OC43</td><td></td></tr><tr><td>Kaempferol derivatives Baicalin from Scutellaria baicalensis</td><td>Inhibit 3a ion channel of coronavirus</td><td>[73]</td></tr><tr><td>Saikosaponins</td><td>Inhibit Angiotensin-converting enzyme (ACE) Prevent the early stage of HCoV-22E9 infection,including viral attchment and</td><td>[44,68] [74]</td></tr><tr><td></td><td>penetration</td><td></td></tr><tr><td>Tetra-O-galloyl-β-D-glucoseand luteolin,from Galla chinensis and Veronicalina riifolia respectively</td><td>Avidly binds with surface spike protein of SARS-CoV</td><td>[71]</td></tr></table></body></html>

The helicase protein is also considered as a potential target for the development of anti-HCoV (human coronavirus) agents. Yu et al. reported scutellarein and myricetin potently inhibited the nsP13 (SARS-CoV helicase protein) in vitro by affecting the ATPase activity [61]. The RNAdependent RNA polymerase (RdRp), a key enzyme responsible for both positive and negative-strand RNA synthesis, also represents another potential druggable target. It was shown that the extracts of Kang Du Bu Fei Tang $( \mathrm { I C 5 0 { : } 4 7 1 . 3 \ \mu g / m L } )$ ), Sinomenium acutum (IC50:198.6 $\mu \mathrm { g } / \mathrm { m L }$ ), Coriolus versicolor $( \mathrm { I C 5 0 { : } 1 0 8 { . } 4 \ \mu g / m L } )$ and Ganoderma lucidum (IC50:41.9 $\mu \mathrm { g } / \mathrm { m L } )$ inhibited SARS-CoV RdRp in a dosedependent manner [54]. Wu et al. performed largescale screening of existing drugs, natural products, and synthetic compounds ${ \tt > } 1 0 0 0 0$ compounds) to identify effective anti-SARS-CoV agents through a cell-based assay with SARS virus and Vero E6 cells [62]. They found that ginsenoside-Rb1 isolated from Panax ginseng, aescin isolated from the horse chestnut tree, reserpine contained in the genus Rauwolfia and extracts of eucalyptus and Lonicera japonica inhibited SARS-CoV replication at non-toxic concentrations [62].

Same as SARS-CoV and HCoV-NL63, SARS-CoV-2 uses host receptor ACE2 for the cellular entrance [63-66]. Therefore, TCM with the capacity to target ACE2 holds the promise to prevent the infection of SARS-CoV-2. Emodin from genus Rheum and Polygonum [67], baicalin from in Scutellaria baicalensis [44, 68], nicotianamine from foodstuff (especially “soybean ACE2 inhibitor (ACE2iSB)”) [69], scutellarin [70], tetra-O-galloyl- $\cdot \beta$ -D-glucose (TGG) from Galla chinensis and luteolin from Veronicalina riifolia [71] markedly inhibited the interaction of SARS-CoV S-protein and ACE2. However, the anti-SARS-CoV activity of these compounds remain to be evaluated. In addition, inhibition of the 3a ion channel by emodin [72] or kaempferol derivativesjuglanin [73] could potentially prevent the viral release from the infected cells. Saikosaponins [74], glycyrrhizin [48, 75], quercetin and TSL-1 extracted from Toona sinensis Roem [76] purportedly had potent anti-SARS-CoV effects by inhibition of viral cellular entry, adsorption, and penetration.

Overwhelming inflammatory responses are attributable to the deaths of patients with infection of SARS-CoV, or MERS-CoV, or COVID-19. Thus, anti-inflammatory agents presumably could reduce the severity and mortality rate [77]. Shuang Huang Lian, a TCM herbal product prepared from Lonicerae japonicae Flos, Scutellariae radix and Fructus forsythia, purportedly had the activity to inhibit SARS-CoV-2 [78]. Interestingly, We have shown that this herbal preparation potently inhibited staphylococcal toxic shock syndrome toxin 1 (TSST-1)-induced production of cytokines $( \mathrm { I L - 1 } \beta ,$ IL-6, TNF- $\cdot \mathbf { a } ,$ IFN-γ) and chemokines $( \mathrm { M I P - 1 } \alpha ,$ $\mathrm { M I P - 1 \beta }$ and MCP-1) by peripheral blood mononuclear cell (PBMC) [79]. In line with our results, this herbal product was shown to markedly reduced the transcriptional and translational levels of inflammatory cytokines TNF- $\cdot \mathbf { a } ,$ $\mathrm { I L - } 1 \beta ,$ , and IL-6 in lipopolysaccharide-stimulated murine alveolar macrophages [80]. Indirubin is an active ingredient of a TCM preparation Dang Gui Long Hui Pill, had strong antiviral and immunomodulatory effects, as shown by a study based on the observation of influenza H5N1 virus-infected human macrophages and type-I alveolar epithelial cells [81]. Lian Hua Qing Wen Capsule was reported to have in vitro activity in inhibition of propagation of various influenza viruses. This TCM herbal product not only blocked the early stages of influenza virus infection but also inhibited virus-induced gene expression of IL-6, IL-8, TNF-a, IP-10, and MCP-1 [82]. Additionally, a study by Dong et al. reported that the levels of IL-8, TNF-α, IL-17, and IL-23 in the sputum and of IL-8 and IL-17 in the blood were markedly decreased after Lian Hua Qing Wen Capsule treatment in patients with acute exacerbation of chronic obstructive pulmonary disease [83]. A self-control study by Poon et al. showed that the administration of the TCM herbal formulas (Sang Ju Yin and Yu Ping Feng San) may have beneficial immunomodulatory effects for the prevention of viral infections including SARS-CoV [46].

Moreover, a number of anti-coronaviral agents have been identified from TCM herbs, although the mechanisms of action have not yet been elucidated. For example, extracts from Lycoris radiata, Artemisia annua, Pyrrosia lingua, and Lindera aggregate possessed the anti–SARS-CoV activity [84], $3 \beta$ -Friedelanol isolated from Euphorbia neriifolia [85], Blancoxanthone isolated from the roots of Calophyllum blancoi [86] exhibited anti-HCoV-229E activity.

# Traditional Chinese Medicine used in the treatment of SARS-CoV-2-infected patients: the current situations

TCM is highly valued by the government of China in their campaign to contain and eradiate SARS-CoV-2. For example, Health Commission in 26 provinces have officially declared that TCM should be used in combination with conventional medicine in the treatment of COVID-19 patients. On 17, February, National Health Commission (NHC) of the People’s Republic of China reported that 60,107 confirmed COVID-19 patients $( 8 5 . 2 0 \%$ of total confirmed cases) had been treated with TCM [87]. As for March 1, 2020, a total of 303 ongoing clinical trials aiming to evaluate the efficacy and safety of treatments for CoV-19 patients have been launched in China. Among them, 50 trials $( 1 6 . 5 \% )$ are about the use of TCM, including 14 cases $( 4 . 6 \% )$ to examine the effect of combined treatment with TCM and Western medicine. In 22 TCM trials $( 7 . 3 \% )$ , the effect of self-made herbal preparations such as Xin Guan-1 Formula, Xin Guan-2 Formula and Qing Yi-4 are examined. In another 14 TCM trials $( 4 . 6 \% )$ , commercially available TCM products such as Tan Re Qing Injection and Lian Hua Qing Wen Capsule are studied (Table 4).

To date, NHC has published 6 editions Guidelines of Diagnosis and Treatment for COVID-19 [88]. Since the fourth versions, different herbal medicines used in TCM system has been recommended for the treatment of COVID-19, based on the stage of disease and symptom differentiation [89]. According to the latest edition of Guideline [88], following multiple component Chinese herbal products are recommended for the patients in the medical observation period, presumably as a preventive measure: Huo Xiang Zheng Qi Shui, Lian Hua Qing Wen Capsule, Shu Feng Jie Du Capsule and Jin Hua Qing Gan Granule. In the clinical treatment period, Qing Fei Pai Du Tang, Xi Yan Ping injection, Xue Bi Jing injection, Re Du Ning injection, Tan Re Qing Injection,

Xing Nao Jing Injection and some other Chinese medicine formulae should be selected [90]. In addition, for the patients in critical condition, Shen Fu injection, Sheng Mai Injection, Shen Mai Injection, Su He Xiang Pill and An Gong Niu Huang Pill should be administered (Table 5).

Through analysis of the frequency of TCM used in 23 provinces, Luo, et al. [37] concluded that Astragalus membranaceus, Glycyrrhizae uralensis, Saposhnikoviae divaricata, Rhizoma Atractylodis Macrocephalae, Lonicerae Japonicae Flos, Fructus forsythia, Atractylodis Rhizoma, Radix platycodonis, Agastache rugosa, and Cyrtomium fortune J. Sm were 10 most commonly used Chinese herbs in the treatment of COVID-19. Xu, et al. [91] reported that Astragalus membranaceus and Yu Ping Feng san were used in the 13 prevention programs (in Beijing, Tianjin, et al.) for “reinforcing vital qi”, a terminology used in TCM that is similar to boosting host defense capacity. Ophiopogon japonicas and Scrophularia ningpoensisand are TCM herbs which were most frequently used for “nourishing yin” in northern China, while Atractylodis Rhizoma, Agastache rugosa and other Chinese medicinal herbs with the property of “aromatic dehumidification” were commonly used in southern China (Table 6).

Table 4. Ongoing TCM Clinical Trials for the treatment of SARS-CoV-2 infection   

<html><body><table><tr><td>Registration number</td><td>Design Title type</td><td></td><td>TCMherbal medicine</td><td>Sample Phase size</td><td></td></tr><tr><td>ChiCTR2000029432 CCT</td><td></td><td>Areal world study for the efficacy and safety of large dose Tanreqing Injection in the treatment of patients with novel coronavirus pneumonia (COVID-19)</td><td>Injection Tan Re Qing</td><td>72</td><td>4</td></tr><tr><td>ChiCTR2000029434 RCT</td><td></td><td>A randomized,open-label, blank-controlled trial for Lian-Hua Qing-Wen Capsule/Granule in the treatment of novel coronavirus pneumonia (COVID-19)</td><td>Lian Hua Qing Wen 400 Capsule/Granule</td><td></td><td>4</td></tr><tr><td>ChiCTR2000029487 CCT</td><td></td><td>Clinical study for Gu-Biao Jie-Du-Ling in preventing of novel coronavirus pneumonia (COVID-19) in children</td><td>Gu Biao Jie Du Ling 200</td><td></td><td>0</td></tr><tr><td>ChiCTR2000029589 CCT</td><td></td><td>An open, prospective, multicenter clinical study for the eficacy and safety of Reduning injection in the treatment of ovel coronavirus pneumonia (COVID-19)</td><td>Re Du Ning Injection</td><td>60</td><td>0</td></tr><tr><td>ChiCTR2000029605 RCT</td><td></td><td>Arandomized,open-label,blank-controled,multicentertrialforShuang-Huang-Lianoral Shuang HuangLian400 solution in the treatment of novel coronavirus pneumonia (COVID-19)</td><td>oral Liquid</td><td></td><td>4</td></tr><tr><td>ChiCTR2000029780 RCT</td><td></td><td>A multicenter,randomized,open,controlled trial for the efficacy and safety of Shen-Qi Fu-Zheng injection in the treatment of novel coronavirus pneumonia (COVID-19)</td><td>Shen Qi Fu Zheng Injection</td><td>160</td><td>4</td></tr><tr><td>ChiCTR2000029781 RCT</td><td></td><td>A multicenter,randomized,open and controlled trial for the efficacy and safety of Kang-Bing-Du granules in the treatment of novel coronavirus pneumonia (COVID-19)</td><td>Kang Bing Du Granules</td><td>160</td><td>4</td></tr><tr><td>ChiCTR2000029822 RCT</td><td></td><td>Arandomized controlledtrialfor honeysuckle decoctionin the treatmentof patients withJinYin Hua Tang novel coronavirus (COVID-19) infection</td><td></td><td>110</td><td>0</td></tr><tr><td>ChiCTR2000029991 RCT</td><td></td><td>Arandomized,open-label, controlled trialfor thesafety and eficiency of Kesuting syrupKe Su Ting Syrup and Keqing capsule in the treatment of mild and moderate novel coronavirus pneumonia /Ke Qing Capsule</td><td></td><td>72</td><td>4</td></tr><tr><td>ChiCTR2000030043 RCT</td><td></td><td>(COVID-19) Shen-Fu injection in the treatment of severe novel coronavirus pneumonia (COVID-19): aShen Fu Injection multicenter, randomized,open-label,controlled trial</td><td></td><td>300</td><td>4</td></tr><tr><td>ChiCTR2000030117 RCT</td><td></td><td>A multicenter, randomized,open,parallel controlled trial for the evaluation of the effectiveness and safety of Xiyanping injection in the treatment of common type novel</td><td>Injection Xi Yan Ping</td><td>348</td><td>4</td></tr><tr><td>ChiCTR2000030255RCT</td><td></td><td>coronavirus pneumonia (COVID-19) Efficacy and safety of Jing-Yin Granule in the treatment of novel coronavirus pneumonia</td><td>Jing Yin Granule</td><td>300</td><td>4</td></tr><tr><td>ChiCTR2000030388 RCT</td><td></td><td>(COVID-19) wind-heat syndrome Efficacy and safety of Xue-Bi-Jing injection in the treatment of severe cases of novel</td><td>Xue Bi Jing Injection 60</td><td></td><td>0</td></tr><tr><td>ChiCTR2000029813 RCT</td><td></td><td>coronavirus pneumonia (COVID-19) Clinical Trial for Tanreqing Capsules in the Treatment of Novel Coronavirus Pneumonia (COVID-19)</td><td>Capsules Tan Re Qing</td><td>72</td><td></td></tr></table></body></html>

Notes: RCT: randomized controlled trial; CCT: controlled clinical trial.

Table 5. TCM recommended by 6th editions Guidelines of Diagnosis and Treatment for COVID-19 [88].   

<html><body><table><tr><td>Stage of disease</td><td>Symptom</td><td>Recommended Chinese patent medicine</td></tr><tr><td rowspan="2"></td><td>Medical observation period Fatigue with gastrointestinal discomfort</td><td>Huo Xiang Zheng Qi Shui</td></tr><tr><td>Fatigue with fever</td><td>Lian Hua Qing Wen Capsule,Shu Feng JieDu Capsule,Jin Hua QingGan Capsule</td></tr><tr><td rowspan="4">Clinical treatment period (Confirmed patients)</td><td>Mild cases</td><td>Qing Fei Pai Du Tang</td></tr><tr><td>General cases</td><td>Qing Fei Pai Du Tang</td></tr><tr><td>Several cases</td><td>XiYan PingInjectionXueBiJingnjection,ReDuNingInjection,anReingjection Xing Nao Jing Injection, Qing FeiPai Du Tang</td></tr><tr><td>Critical cases</td><td>XueBiJingeogeoeeoe MaiInjection,henaijection,SuHeiangill,AnGongiuHugill</td></tr></table></body></html>

Table 6. Frequently used TCM herbs for the Prevention of COVID-19 infection   

<html><body><table><tr><td>Reported by</td><td>Herbs (Latin name)</td><td>Herbs (Chinese Pin Yin)</td><td> Applicable regions</td></tr><tr><td>Luo, et al. [37]</td><td>Astragalusmembranaceus Glycyrrhizae uralensis</td><td>Huangqi</td><td>23 provincesoveredrtheast,orthCentralining Wuhan),South, East, Northwest,and Southwest China.</td></tr><tr><td></td><td>Saposhnikoviae divaricata</td><td>Gancao Fangfeng</td><td></td></tr><tr><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Rhizoma Atractylodis Macrocephalae</td><td>Baizhu</td><td></td></tr><tr><td></td><td>Lonicerae Japonicae Flos</td><td> Jinyinhua</td><td></td></tr><tr><td></td><td>Fructus forsythia</td><td>Lianqiao</td><td></td></tr><tr><td></td><td>Atractylodis Rhizoma</td><td>Cangzhu</td><td></td></tr><tr><td></td><td>Radix platycodonis</td><td>Jiegeng</td><td></td></tr><tr><td></td><td>Agastache rugosa</td><td>Huoxiang</td><td></td></tr><tr><td></td><td>Cyrtomium fortune J.Sm</td><td>Guanzhong</td><td></td></tr><tr><td> Xu, et al. [91]</td><td>Astragalus membranaceus</td><td>Huangqi</td><td>Beijing,Tianjin,Shandong, Shaanxi, Gansu,Hebei,Shanxi, Henan,Hubei, Jiangxi, Hunan,and Yunnan</td></tr><tr><td></td><td>Atractylodis Rhizoma</td><td>Cangzhu</td><td>Five regions in southern China (Hubei, Jiangxi, Hunan,</td></tr><tr><td></td><td>Eupatori Herba</td><td>Peilan</td><td>Yunnan,and Wuhan)</td></tr><tr><td></td><td>Agastache rugosa</td><td>Huoxiang</td><td></td></tr><tr><td></td><td>Ophiopogon japonicas</td><td>Maidong</td><td>Eight regions in northern China (Beijing, Tianjin, Hebei,</td></tr><tr><td></td><td>Scrophularia ningpoensis</td><td> Xuanshen</td><td>Henan, Shaanxi, Shanxi,Gansu,and Shandong)</td></tr><tr><td></td><td>Rhizoma phragmitis</td><td>Lugen</td><td></td></tr><tr><td></td><td></td><td>Shashen</td><td></td></tr><tr><td></td><td>Adeinophora stricta Miq Dendrobium nobile Lindl.</td><td>Shihu</td><td></td></tr></table></body></html>

According to the report of National Administration of Traditional Chinese Medicine, up to February 5th, 2020, 214 COVID-19 patients were treated with Qing Fei Pai $D u$ Tang in Shanxi, Hebei, Heilongjiang and Shaanxi Provinces with overall effective rate $\geq 9 0 \%$ . Among them, the symptoms of majority of patients $( 2 6 0 \% )$ were markedly improved, while illness of others $( 3 0 \% )$ was stabilized [92]. After that, 701 COVID-19 patients were treated with Qing Fei Pai Du Tang in 10 provinces in China. The result showed that 130 patients $( 1 8 . 5 \% )$ were completely cured after treatment. The treatment also resulted in the disappearance of characteristic symptoms of COVID-19 such as fever and cough in 51 patients $( 7 . 2 7 \% )$ . In addition, symptom improvement or stabilization were observed in 268 patients $( 3 8 . 2 \% )$ and in 212 patients $( 3 0 . 2 \% )$ , respectively [87]. Yao, et al. and Lu, et al. [93, 94] retrospectively analyzed the clinical efficacy of Lian Hua Qing Wen Capsule in treatment of confirmed and suspected COVID-19 patients. The results indicated that this herbal product could markedly relieve major symptoms such as fever and cough and had the capacity to promote the recovery.

Some patients with mild illness in the early stage could suddenly progress to severe disease, and eventually died due to septic shock with multiple organ dysfunction syndrome (MODS), which was associated with cytokine storm [95]. There is compelling evidence that some TCM herbal products or its components have potent immunosuppressive effects, as shown by our own and other’s studies [79, 96-103]. For example, Wang, et al. [104] reported that Shen Fu Injection could inhibit the lung inflammation and decrease the levels of $\mathrm { I L - } 1 \beta ,$ , IL-6 and other cytokines. Chang, et al. [105] reported that Re Du Ning Injection could markedly reduce the levels of $\mathrm { I L - } 1 \beta ,$ TNF- $\mathbf { \sigma } _ { \cdot \mathbf { q } }$ , IL-8, IL-10, and some other cytokines of LPS-induced model of acute lung injury in rats. We recently reported that tetrandrine, a compound isolated from an anti-rheumatic Chinese herb, could potently inhibit proinflammatory Th1, Th2 and Th17 responses in LPS-challenged mice [106]. Therefore, TCM with the capacity to inhibit cytokine storm and its devastating consequences may be harnessed in the treatment of severe COVID-19 patients.

Currently, the laboratory study on the effect of TCM is apparently lagging behind the clinical application of TCM in the treatment of COVID-19 patients. Nevertheless, some scientists have started to examine the effect of TCM products or its components on SARS-CoV-2 in their laboratories. For example, an in vitro study showed that Shuang Huang Lian Oral Liquid had the inhibitory effect on SARS-CoV-2 [78]. However, its clinical efficacy and safety for the treatment of COVID-19 patients has not been evaluated. We noticed that this TCM product was not recommend by HNC’s Guideline [89]. Same as SARS-CoV, SARS-CoV-2 uses receptor ACE2 for the cellular entrance [8]. Theoretically, blockade of ACE2 can prevent the infection of SARS-CoV-2. Chen and Du thus performed the molecular docking study and they found that TCM-derived compounds, including as baicalin, scutellarin, hesperetin, glycyrrhizin and nicotianamine could interact with ACE2 [107]. Therefore, these compounds as well as herbs containing these ingredients may have the capacity to inhibit the infection of SARS-CoV-2. We anticipate more experiment studies showing anti-SARS-CoV-2 activity of TCM or its components will be published in the near future.

# Closing remarks

TCM has accumulated thousand-of-year’s experiences in the treatment of pandemic and endemic diseases. Providing complementary and alternative treatments are still urgently needed for the management of patients with SARS-CoV-2 infection, experiences in TCM is certainly worth learning. Fighting against current epidemics also provide an opportunity to test the true value of TCM in treating emerging contagious diseases. Randomized, double-blind and placebo-controlled studies is the best way to provide the most reliable evidence for a therapy, including TCM. It is encouraging that the controlled clinical studies to evaluate the efficacy of TCM in the treatment of SARS-CoV were conducted and reported. However, the most of these studies were found to be poorly designed and the results could lead to potential biases in evaluating the effectiveness of TCM treatment [13]. Hopefully, current clinical study to evaluate the effect of TCM on COVID-19 will use more strict protocols, concealment of allocation, and double-blinding, in order to ensure the compliance of international acceptable standards. Furthermore, standardized products of TCM, rather than self-prepared formulations, should be used in clinical study. Experiment study may be able to elucidate the mechanism underlying the therapeutic effect of TCM in the treatment of COVID-19. The further study of TCM may lead to the identification of novel anti human coronavirus compounds that may eventually prove to be useful in the treatment of SARS-CoV-2 or other emerging fatal viral diseases as conventional therapeutic agents.

The safety of TCM in the treatment of emerging coronavirus diseases was not included in the observation on SARS patients [13]. It was reported that some herbs used in TCM contain nephrotoxins and mutagens [108], while the toxicological features of the most of Chinese herbal medicines remain to be fully understood [109]. Furthermore, herbs used in TCM can mimic, or magnify, or oppose the effect of conventional medicines [110]. Thus, the safety of TCM used in treatment of emerging coronavirus infections should be carefully evaluated. It is particularly important to avoid toxicity or interfere with the efficacy of conventional treatment caused by herb-drug interaction.

# Supplementary Material

Supplementary figures and tables. http://www.ijbs.com/v16p1708s1.pdf

# Acknowledgement

This project has been funded by Macau Science and Technology Development Fund (FDCT) research grant 201/2017/A3 and 0056/2019/AFJ and University of Macau research grant MYRG2017-00120- ICMS and MYRG2019-00169-ICMS.

# Competing Interests

The authors have declared that no competing interest exists.

# References

1. Gralinski LE, Menachery VD. Return of the Coronavirus: 2019-nCoV. Viruses. 2020; 12.   
2. Burki TK. Coronavirus in China. Lancet Respir Med. 2020.   
3. World Health Organization. WHO Director-General's remarks at the media briefing on 2019-nCoV on 11 February 2020. https://www.who.int/dg/ speeches/detail/who-director-general-s-remarks-at-the-media-briefing-on-20 19-ncov-on-11-february-2020. 2020.   
4. Guan W-j, Ni Z-y, Hu Y, Liang W-h, Ou $\mathbf { C - q } ,$ He J- $\cdot \mathbf { x } ,$ et al. Clinical characteristics of 2019 novel coronavirus infection in China. medRxiv. 2020: 2020.02.06.20020974.   
5. Huang C, Wang Y, Li X, Ren L, Zhao J, Hu Y, et al. Clinical features of patients infected with 2019 novel coronavirus in Wuhan, China. Lancet. 2020; 395(10223):497-506.   
6. World Health Organization. Situation Report-29. https://www.who.int/ docs/default-source/coronaviruse/situation-reports/20200218-sitrep-29-covi d-19.pdf?sfvrsn=6262de9e_2. 2020.   
7. Chen N, Zhou M, Dong X, Qu J, Gong F, Han Y, et al. Epidemiological and clinical characteristics of 99 cases of 2019 novel coronavirus pneumonia in Wuhan, China: a descriptive study. Lancet. 2020; 395(10223):507-513.   
8. Zhou P, Yang XL, Wang XG, Hu B, Zhang L, Zhang W, et al. A pneumonia outbreak associated with a new coronavirus of probable bat origin. Nature. 2020.   
9. Wu A, Peng Y, Huang B, Ding X, Wang X, Niu P, et al. Genome Composition and Divergence of the Novel Coronavirus (2019-nCoV) Originating in China. Cell Host Microbe. 2020.   
10. Zumla A, Chan JF, Azhar EI, Hui DS, Yuen KY. Coronaviruses - drug discovery and therapeutic options. Nat Rev Drug Discov. 2016; 15: 327-47.   
11. Xie X, Zhong Z, Zhao W, Zheng C, Wang F, Liu J. Chest CT for Typical 2019-nCoV Pneumonia: Relationship to Negative RT-PCR Testing. Radiology. 2020: 200343.   
12. Li $G ,$ Clercq ED. Therapeutic options for the 2019 novel coronavirus (2019-nCoV). Nat Rev Drug Discov. 2020.   
13. Liu J, Manheimer E, Shi Y, Gluud C. Chinese herbal medicine for severe acute respiratory syndrome: a systematic review and meta-analysis. J Altern Complement Med.. 2004; 10: 1041-51.   
14. Li T, Peng T. Traditional Chinese herbal medicine as a source of molecules with antiviral activity. Antiviral Res. 2013; 97: 1-9.   
15. Leung PC. The efficacy of Chinese medicine for SARS: a review of Chinese publications after the crisis. Am J Chin Med. 2007; 35: 575-81.   
16. Jin YH, Cai ${ \mathrm { L } } ,$ Cheng ZS, Cheng H, Deng T, Fan YP, et al. A rapid advice guideline for the diagnosis and treatment of 2019 novel coronavirus (2019-nCoV) infected pneumonia (standard version). Mil Med Res. 2020; 7: 4.   
17. Habibzadeh P, Stoneman EK. The Novel Coronavirus: A Bird's Eye View. Int J Occup Environ Med. 2020; 11: 65-71.   
18. Jordan PC, Stevens SK, Deval J. Nucleosides for the treatment of respiratory RNA virus infections. Antivir Chem Chemother. 2018; 26: 2040206618764483.   
19. De Clercq E. New Nucleoside Analogues for the Treatment of Hemorrhagic Fever Virus Infections. Chem Asian J. 2019; 14: 3962-8.   
20. Wang M, Cao R, Zhang L, Yang X, Liu J, Xu M, et al. Remdesivir and chloroquine effectively inhibit the recently emerged novel coronavirus (2019-nCoV) in vitro. Cell Res. 2020.   
21. Sheahan TP, Sims AC, Graham ${ \mathrm { R L } } ,$ Menachery VD, Gralinski LE, Case JB, et al. Broad-spectrum antiviral GS-5734 inhibits both epidemic and zoonotic coronaviruses. Sci Transl Med. 2017; 9.   
22. Zhang L, Liu Y. Potential Interventions for Novel Coronavirus in China: A Systemic Review. J Med Virol. 2020.   
23. Holshue ${ \mathrm { M L } } ,$ DeBolt C, Lindquist S, Lofy KH, Wiesman J, Bruce H, et al. First Case of 2019 Novel Coronavirus in the United States. N Engl J Med. 2020.   
24. Lai CC, Shih TP, Ko WC, Tang HJ, Hsueh PR. Severe acute respiratory syndrome coronavirus 2 (SARS-CoV-2) and corona virus disease-2019 (COVID-19): the epidemic and the challenges. Int J Antimicrob Agents. 2020:   
105924.   
25. Savarino A, Di Trani ${ \mathrm { L } } ,$ Donatelli I, Cauda R, Cassone A. New insights into the antiviral effects of chloroquine. Lancet Infect Dis. 2006; 6: 67-9.   
26. Yan Y, Zou Z, Sun Y, Li X, Xu KF, Wei Y, et al. Anti-malaria drug chloroquine is highly effective in treating avian influenza A H5N1 virus infection in an animal model. Cell Res. 2013; 23: 300-2.   
27. Wong CK, Lam CW, Wu AK, Ip WK, Lee ${ \mathrm { N L } } ,$ Chan IH, et al. Plasma inflammatory cytokines and chemokines in severe acute respiratory syndrome. Clin Exp Immuno. 2004; 136: 95-103.   
28. He L, Ding Y, Zhang $\mathrm { \sf Q } ,$ Che X, He Y, Shen H, et al. Expression of elevated levels of pro-inflammatory cytokines in SARS-CoV-infected $_ { \mathrm { A C E 2 + } }$ cells in SARS patients: relation to the acute lung injury and pathogenesis of SARS. J Pathol. 2006; 210: 288-97.   
29. Faure E, Poissy J, Goffard A, Fournier C, Kipnis E, Titecat M, et al. Distinct immune response in two MERS-CoV-infected patients: can we go from bench to bedside? PLoS One. 2014; 9: e88716.   
30. Falzarano D, de Wit E, Rasmussen AL, Feldmann F, Okumura A, Scott DP, et al. Treatment with interferon-alpha2b and ribavirin improves outcome in MERS-CoV-infected rhesus macaques. Nat Med 2013; 19: 1313-7.   
31. Stockman LJ, Bellamy R, Garner P. SARS: systematic review of treatment effects. PLoS Med. 2006; 3: e343.   
32. Lansbury ${ \mathrm { L } } ,$ Rodrigo $C ,$ Leonardi-Bee J, Nguyen-Van-Tam J, Lim WS. Corticosteroids as adjunctive therapy in the treatment of influenza. Cochrane Database Syst Rev. 2019; 2: Cd010406.   
33. Arabi YM, Mandourah Y, Al-Hameed F, Sindi AA, Almekhlafi GA, Hussein MA, et al. Corticosteroid Therapy for Critically Ill Patients with Middle East Respiratory Syndrome. Am J Respir Crit Care Med. 2018; 197: 757-67.   
34. Russell CD, Millar JE, Baillie JK. Clinical evidence does not support corticosteroid treatment for 2019-nCoV lung injury. Lancet. 2020.   
35. World Health Organization. https://www.who.int/internal-publicationsdetail/clinical-management-of-severe-acute-respiratory-infection-when-novel -coronavirus-(ncov)-infection-is-suspected. 2020.   
36. Hung IFN, To KKW, Lee CK, Lee KL, Yan WW, Chan K, et al. Hyperimmune IV immunoglobulin treatment: a multicenter double-blind randomized controlled trial for patients with severe 2009 influenza A(H1N1) infection. Chest. 2013; 144: 464-73.   
37. Luo H, Tang QL, Shang YX, Liang SB, Yang M, Robinson N, et al. Can Chinese Medicine Be Used for Prevention of Corona Virus Disease 2019 (COVID-19)? A Review of Historical Classics, Research Evidence and Current Prevention Programs. Chin J Integr Med. 2020.   
38. Tong X, Li A, Zhang Z, Duan J, Chen X, Hua $C ,$ et al. TCM treatment of infectious atypical pneumonia--a report of 16 cases. J Tradit Chin Med. 2004;   
24: 266-9.   
39. Liu X, Zhang M, He L, Li Y. Chinese herbs combined with Western medicine for severe acute respiratory syndrome (SARS). Cochrane Database Syst Rev.   
2012; 10: Cd004882.   
40. Zhang MM, Liu XM, He L. Effect of integrated traditional Chinese and Western medicine on SARS: a review of clinical evidence. World J Gastroenterol. 2004; 10: 3500-5.   
41. Zhong N, May RM, McLean AR, Pattison J, Weiss RA. Management and prevention of SARS in China. Philos Trans R Soc Lond B Biol Sci. 2004; 359:   
1115-6.   
42. JSM P, D P, Yuen KY ea. The Severe Acute Respiratory Syndrome. New Engl J Med.. 2003; 249: 2431-41.   
43. Jr TMF, Tsang KWT. Severe Acute Respiratory Syndrome. Nat Med. 2005; 4:   
95-106.   
44. Chen $Z ,$ Nakamura T. Statistical evidence for the usefulness of Chinese medicine in the treatment of SARS. Phytotherapy research $:$ PTR. 2004; 18:   
592-4.   
45. T.F. Lau, Leung PC, Wong ELY, Fong C, Cheng KF, Zhang SC, et al. Using Herbal Medicine as a Means of Prevention Experience During the SARS Crisis. Am J Chin Med. 2005; 33: 345-56.   
46. Poon PM, Wong CK, Fung KP, Fong $\operatorname { C Y } ,$ Wong $\scriptstyle \mathrm { E L } ,$ Lau $\operatorname { J T } ,$ et al. Immunomodulatory effects of a traditional Chinese medicine with potential antiviral activity: a self-control study. Am J Chin Med. 2006; 34: 13-21.   
47. Hsu CH, Hwang KC, Chao $\mathrm { C L } ,$ Chang SG, Ho MS, Chou P. Can herbal medicine assist against avian flu? Learning from the experience of using supplementary treatment with Chinese medicine on SARS or SARS-like infectious disease in 2003. J Altern Complement Med. 2006; 12: 505-6.   
48. Cinatl J, Morgenstern B, Bauer $G ,$ Chandra P, Rabenau H, Doerr HW. Glycyrrhizin, an active component of liquorice roots, and replication of SARS-associated coronavirus. The Lancet. 2003; 361: 2045-6.   
49. Chen F, Chan KH, Jiang Y, Kao RY, Lu HT, Fan KW, et al. In vitro susceptibility of 10 clinical isolates of SARS coronavirus to selected antiviral compounds. J Clin Virol. 2004; 31: 69-75.   
50. Wang SQ, Du QS, Zhao K, Li AX, Wei DQ, Chou KC. Virtual screening for finding natural inhibitor against cathepsin-L for SARS therapy. Amino Acids. 2007; 33: 129-35.   
51. Wu T, Yang X, Zeng X, Poole P. Traditional Chinese medicine in the treatment of acute respiratory tract infections. Resp Med. 2008; 102: 1093-8.   
52. Cragg GM, Newman DJ. Natural products: a continuing source of novel drug leads. Biochimica et biophysica acta. 2013; 1830: 3670-95.   
53. Luo W, Su X, Gong S, Qin Y, Liu W, Li J, et al. Anti-SARS coronavirus 3C-like protease effects of Rheum palmatum L. extracts. BioScience Trends. 2009; 3.   
54. Fung KP, Leung PC, Tsui KW, Wan CC, Wong KB, Waye MY, et al. Immunomodulatory activities of the herbal formula Kwan Du Bu Fei Dang in healthy subjects: a randomised, double-blind, placebo-controlled study. Hong Kong Med J. 2011; 17 Suppl 2: 41-3.   
55. Lau KM, Lee KM, Koon CM, Cheung CS, Lau CP, Ho HM, et al. Immunomodulatory and anti-SARS activities of Houttuynia cordata. J Ethnopharmacol. 2008; 118: 79-85.   
56. Gong SJ, Su XJ, Yu HP, Li J, Qin YJ, $\scriptstyle \mathtt { X u Q } ,$ et al. A study on anti-SARS-CoV 3CL protein of flavonoids from litchi chinensis sonn core. Chinese Pharmacological Bulletin. 2008; 24: 699-700.   
57. Lin CW, Tsai FJ, Tsai CH, Lai CC, Wan L, Ho TY, et al. Anti-SARS coronavirus 3C-like protease effects of Isatis indigotica root and plant-derived phenolic compounds. Antiviral Res. 2005; 68: 36-42.   
58. Nguyen TTH, Woo H-J, Kang H-K, Nguyen VD, Kim Y-M, Kim D-W, et al. Flavonoid-mediated inhibition of SARS coronavirus 3C-like protease expressed in Pichia pastoris. Biotechnol Lett. 2012; 34: 831-8.   
59. Jo S, Kim S, Shin DH, Kim M-S. Inhibition of SARS-CoV 3CL protease by flavonoids. J Enzyme Inhib Med Chem. 2020; 35: 145-51.   
60. Jo S, Kim H, Kim S, Shin DH, Kim MS. Characteristics of flavonoids as potent MERS‐CoV 3C‐like protease inhibitors. Chem Biol Drug Des. 2019.   
61. Yu MS, Lee J, Lee JM, Kim Y, Chin YW, Jee JG, et al. Identification of myricetin and scutellarein as novel chemical inhibitors of the SARS coronavirus helicase, nsP13. Bioorg Med Chem Lett. 2012; 22: 4049-54.   
62. Wu CY, Jan JT, Ma SH, Kuo CJ, Juan HF, Cheng YSE, et al. Small molecules targeting severe acute respiratory syndrome human coronavirus. Proc Natl Acad Sci U S A. 2004; 101: 10012-7.   
63. Kuhn JH, Radoshitzky SR, Li W, Wong SK, Choe H, Farzan M. The SARS Coronavirus receptor ACE 2 A potential target for antiviral therapy. In: Holzenburg A, Bogner E, editors. New Concepts of Antiviral Therapy. Boston, MA: Springer US; 2006. p. 397-418.   
64. Letko M, Munster V. Functional assessment of cell entry and receptor usage for lineage B $\beta$ -coronaviruses, including 2019-nCoV. bioRxiv. 2020: 2020.01.22.915660.   
65. Lin HX, Feng Y, Wong G, Wang L, Li B, Zhao X, et al. Identification of residues in the receptor-binding domain (RBD) of the spike protein of human coronavirus NL63 that are critical for the RBD–ACE2 receptor interaction. J Gen Virol. 2008; 89: 1015-24.   
66. Xu XT, Chen P, Wang JF, Feng JN, Zhou H, Li X, et al. Evolution of the novel coronavirus from the ongoing Wuhan outbreak and modeling of its spike protein for risk of human transmission. Sci China Life Sci. 2020.   
67. Ho T, Wu S, Chen J, Li C, Hsiang C. Emodin blocks the SARS coronavirus spike protein and angiotensin-converting enzyme 2 interaction. Antiviral Res. 2007; 74: 92-101.   
68. Deng YF, Aluko RE, Jin Q, Zhang Y, Yuan LJ. Inhibitory activities of baicalin against renin and angiotensin-converting enzyme. Pharm Biol. 2012; 50: 401-6.   
69. Takahashi S, Yoshiya T, Yoshizawa-Kumagaye K, Sugiyama T. Nicotianamine is a novel angiotensin-converting enzyme 2 inhibitor in soybean. Biomed Res. 2015; 36: 219-24.   
70. Wang W, Ma X, Han J, Zhou M, Ren H, Pan $\mathrm { Q } ,$ et al. Neuroprotective Effect of Scutellarin on Ischemic Cerebral Injury by Down-Regulating the Expression of Angiotensin-Converting Enzyme and AT1 Receptor. PLoS One. 2016; 11: e0146197.   
71. Yi L, Li Z, Yuan K, Qu X, Chen J, Wang G, et al. Small molecules blocking the entry of severe acute respiratory syndrome coronavirus into host cells. J Virol. 2004; 78: 11334-9.   
72. Schwarz S, Wang K, Yu WJ, Sun B, Schwarz W. Emodin inhibits current through SARS-associated coronavirus 3a protein. Antiviral res. 2011; 90: 64-9.   
73. Schwarz S, Sauter D, Wang K, Zhang R, Sun B, Karioti A, et al. Kaempferol Derivatives as Antiviral Drugs against the 3a Channel Protein of Coronavirus. Planta Medica. 2014; 80: 177-82.   
74. Cheng PW, Ng LT, Chiang LC, Lin CC. Antiviral effects of saikosaponins on human coronavirus 229E in vitro. Clin Exp Pharmacol Physiol. 2006; 33: 612-6.   
75. Pilcher H. Liquorice may tackle SARS. Nature. 2003.   
76. Chen CJ, Michaelis M, Hsu HK, Tsai CC, Yang KD, Wu YC, et al. Toona sinensis Roem tender leaf extract inhibits SARS coronavirus replication. J Ethnopharmacol. 2008; 120: 108-11.   
77. Lu H. Drug treatment options for the 2019-new coronavirus (2019-nCoV). Biosci Trends. 2020.   
78. Science CAo. Researchers in Shanghai Institute of Drugs and Wuhan Virus Institute discovered that the Chinese patent medicine Shuanghuanglian oral liquid can inhibit the 2019-new coronavirus.; 2020.   
79. Chen X, Howard OM, Yang X, Wang L, Oppenheim JJ, Krakauer T. Effects of Shuanghuanglian and Qingkailing, two multi-components of traditional Chinese medicinal preparations, on human leukocyte function. Life Sci. 2002; 70: 2897-913.   
80. Gao Y, Fang L, Cai R, Zong C, Chen X, Lu J, et al. Shuang-Huang-Lian exerts anti-inflammatory and anti-oxidative activities in lipopolysaccharidestimulated murine alveolar macrophages. Phytomedicine. 2014; 21: 461-9.   
81. Chan MC, Chan RW, Mok CK, Mak NK, Wong RN. Indirubin-3'-oxime as an antiviral and immunomodulatory agent in treatment of severe human influenza virus infection. Hong Kong Med J. 2018; 24 Suppl 6: 45-7.   
82. Ding Y, Zeng L, Li R, Chen Q, Zhou B, Chen $\mathrm { Q } ,$ et al. The Chinese prescription lianhuaqingwen capsule exerts anti-influenza activity through the inhibition of viral propagation and impacts immune function. BMC Complement Altern Med. 2017; 17: 130.   
83. Dong L, Xia JW, Gong Y, Chen Z, Yang H-H, Zhang J, et al. Effect of Lianhuaqingwen Capsules on Airway Inflammation in Patients with Acute Exacerbation of Chronic Obstructive Pulmonary Disease. Evid Based Complement Alternat Med 2014; 2014: 1-11.   
84. Li S, Chen C, Zhang H, Guo H, Wang H, Wang ${ \mathrm { L } } ,$ et al. Identification of natural compounds with antiviral activities against SARS-associated coronavirus. Antiviral Res. 2005; 67: 18-23.   
85. Chang FR, Yen CT, Ei-Shazly M, Lin WH, Yen MH, Lin KH, et al. Anti-Human Coronavirus (anti-HCoV) Triterpenoids from the Leaves of Euphorbia Neriifolia. Nat Prod Commun 2012; 7: 1934578X1200701103.   
86. Shen YC, Wang LT, Khalil AT, Chiang LC, Cheng PW. Bioactive Pyranoxanthones from the Roots of Calophyllum blancoi. Chem Pharm Bull. 2005; 53: 244-7.   
87. National Health Commission of the People’s Republic of China. Transcript of press conference in 17, February, 2020. http://www.nhc.gov.cn/xcs/s3574/ 202002/f12a62d10c2a48c6895cedf2faea6e1f. shtml. 2020.   
88. National Health Commission of the People’s Republic of China. Notice on the issunance of guidelines of diagnosis and treatment for 2019-nCoV infected pneumonia (version 6). 6 ed; http://www.nhc.gov.cn/yzygj/s7653p/202002/ 8334a8326dd94d329df351d7da8aefc2.shtml?from=timeline. 2020.   
89. Han YY, Zhao MR, Shi B, Song ZH, Zhou SP, He Y. Application of integrative medicine protocols on treatment of coronavirus disease 2019. Chi Tradit Herbal Drugs. 1-5.   
90. Zhu YG, Deng ZW, Liu LH, Liu XH, Li XZ, Chen WH, et al. Compilation of drug information for the diagnosis and treatment of COVID-19 (version 1). Central South Pharmacy. 1-14.   
91. Xu X, Zhang Y, Li $\mathsf { X } ,$ Li XX. Analysis on prevention plan of corona virus disease-19 (COVID-19) by traditional Chinese medicine in various regions. Chin Herb Med. 2020: 1-7.   
92. Zhao J, Tian SS, Yang J, Liu J, Zhang WD. Investigating the mechanism of Qing-Fei-Pai-Du-Tang for the treatment of Novel Coronavirus Pneumonia by network pharmacology. Chin Herb Med. 2020: 1-7.   
93. Yao KT, Liu MY, Li $\Sigma ,$ Huang JH, Cai HB. Retrospective Clinical Analysis on Treatment of Novel Coronavirus-infected Pneumonia with Traditional Chinese Medicine Lianhua Qingwen. Chin J Exp Tradit Med Form. 2020: 1-7.   
94. Lv RB, Wang WJ, Li X. Treatment of suspected new coronavirus pneumonia with Chinese medicine Lianhua Qingwen Clinical observation of 63 suspected cases. J Tradit Chin Med. 2020: 1-5.   
95. Zhang JW, Hu X, Jin PF. Cytokine storms caused by 2019-nCoV and drug therapy. Chinese Pharmaceutical Journal. 2020: 1-9.96.   
96. Chen $\Sigma ,$ Yang D, Shen W, Dong HF, Wang JM, Oppenheim JJ, et al. Characterization of chenodeoxycholic acid as an endogenous antagonist of the G-coupled formyl peptide receptors. Inflamm Res. 2000; 49: 744-55.   
97. Chen X, Mellon RD, Yang L, Dong H, Oppenheim JJ, Howard OM. Regulatory effects of deoxycholic acid, a component of the anti-inflammatory traditional Chinese medicine Niuhuang, on human leukocyte response to chemoattractants. Biochem Pharmacol. 2002; 63: 533-41.   
98. Chen X, Beutler JA, McCloud TG, Loehfelm A, Yang L, Dong HF, et al. Tannic acid is an inhibitor of CXCL12 (SDF-1alpha)/CXCR4 with antiangiogenic activity. Clin Cancer Res. 2003; 9: 3115-23.   
99. Chen $\mathsf { X } ,$ Yang L, Zhang N, Turpin JA, Buckheit RW, Osterling C, et al. Shikonin, a component of chinese herbal medicine, inhibits chemokine receptor function and suppresses human immunodeficiency virus type 1. Antimicrob Agents Chemother. 2003; 47: 2810-6.   
100. Chen X, Oppenheim JJ, Howard OM. Chemokines and chemokine receptors as novel therapeutic targets in rheumatoid arthritis (RA): inhibitory effects of traditional Chinese medicinal components. Cell Mol Immunol. 2004; 1: 336-42.   
101. Chen X, Murakami T, Oppenheim JJ, Howard OM. Triptolide, a constituent of immunosuppressive Chinese herbal medicine, is a potent suppressor of dendritic-cell maturation and trafficking. Blood. 2005; 106: 2409-16.   
102. He J, He ZD, Chen X. Effects of Chinese medicinal components on chemokine receptors: theory, results and methodology. Evidence-based Research Methods for Chinese Medicine. 2016: 187-97.   
103. Chen YB, Chen X. Ancient herbal component may be a novel therapeutic for gouty arthritis. J Leukoc Biol 2019; 105: 7-9.   
104. Wang J, Qiao LF, Li YS, Yang GT. Shen Fu injection activate the macrophage NF-kB of rats' alveolar induced by LPS. Acta Medicinae Universitatis Scientiae et Technologiae Huazhong. 2009; 1: 15-8.   
105. Chang XJ, Xiao W, Zhang S, Chang YP, Chen CM, Chen J, et al. Mechanism of Re Du Ning injection on anti-acute lung injury in rats based on cytokines storm. Chin Herb Med. 2014; 46: 236-9.   
106. Zou HM, He TZ, Chen X. Tetrandrine inhibits differentiation of proinflammatory subsets of T helper cells but spares de novo differentiation of iTreg cells. Int Immunopharmacol. 2019; 69: 307-12.   
107. Chen H and Du Q. Potential Natural Compounds for Preventing 2019-nCoV Infection. Preprints 2020.   
108. Ng AWT, Poon SL, Huang MN, Lim JQ, Boot A, Yu W, et al. Aristolochic acids and their derivatives are widely implicated in liver cancers in Taiwan and throughout Asia. Sci Trans Med. 2017; 9.   
109. Zeng ZP, Jiang JG. Analysis of the adverse reactions induced by natural product-derived drugs. Br J Pharmacol. 2010; 159: 1374-91.   
110. Fugh-Berman A. Herb-drug interactions. Lancet. 2000; 355: 134-8.   
111. Liu LS, Lei N, Lin $\mathrm { \bf Q , \Lambda }$ Wang WL, Yan HW, Duan XH. The Effects and Mechanism of Yinqiao Powder on Upper Respiratory Tract Infection. Int J Biotechnol Wellness Ind. 2015; 4: 57-60.   
112. Fu YJ, Yan YQ, Qin HQ, Wu S, Shi SS, Zheng $\Sigma ,$ et al. Effects of different principles of Traditional Chinese Medicine treatment on TLR7/NF-κB signaling pathway in influenza virus infected mice. Chin Med. 2018; 13: 42.   
113. Lau JT, Leung PC, Wong EL, Fong C, Cheng KF, Zhang SC, et al. The use of an herbal formula by hospital care workers during the severe acute respiratory syndrome epidemic in Hong Kong to prevent severe acute respiratory syndrome transmission, relieve influenza-related symptoms, and improve quality of life: a prospective cohort study. J Altern Complement Med. 2005; 11: 49-55.   
114. Du CY, Zheng KY, Bi CW, Dong TT, Lin H, Tsim KW. Yu Ping Feng San, an Ancient Chinese Herbal Decoction, Induces Gene Expression of Anti-viral Proteins and Inhibits Neuraminidase Activity. Phytother Res. 2015; 29: 656-61.   
115. Gao J, Li J, Shao $\Sigma ,$ Jin Y, Lu XW, Ge JF, et al. Antiinflammatory and immunoregulatory effects of total glucosides of Yupingfeng powder. Chin Med J (Engl). 2009; 122: 1636-41.   
116. Zhang H, Chen $\mathrm { \sf Q } ,$ Zhou W, Gao S, Lin H, Ye ${ \sf S } ,$ et al. Chinese medicine injection shuanghuanglian for treatment of acute upper respiratory tract infection: a systematic review of randomized controlled trials. Evid Based Complement Alternat Med. 2013; 2013: 987326.   
117. Xiao GL, Song K, Yuan CJ ea. A literature report on the treatment of SARS by stages with traditional Chinese medicine. J Emerg Chin Med Hunan. 2005: 53-5.   
118. Bao L, J M. Research progress of Da Yuan Yin on the treatment of infectious diseases. Emerg Tradit Chin Med. 2010; 2: 263-87.   
119. Kim DE, Min JS, Jang MS, Lee JY, Shin YS, Song JH, et al. Natural Bis-Benzylisoquinoline Alkaloids-Tetrandrine, Fangchinoline, and Cepharanthine, Inhibit Human Coronavirus OC43 Infection of MRC-5 Human Lung Cells. Biomolecules. 2019; 9: 696.